<?php
namespace Codexpert\CoDesigner_Pro;

use Elementor\Utils;
use Elementor\Repeater;
use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use Elementor\Core\Schemes\Color;
use Elementor\Core\Schemes\Typography;
use Elementor\Group_Control_Border;
use Elementor\Group_Control_Typography;
use Elementor\Group_Control_Box_Shadow;
use Elementor\Group_Control_Background;
use Codexpert\CoDesigner\App\Controls\Group_Control_Gradient_Text;

class Floating_Cart extends Widget_Base {

	public $id;

	public function __construct( $data = [], $args = null ) {
		parent::__construct( $data, $args );

	    // Are we in debug mode?
		$min = defined( 'CODESIGNER_PRO_DEBUG' ) && CODESIGNER_PRO_DEBUG ? '' : '.min';

		$this->id = wcd_get_widget_id( __CLASS__ );
		$this->widget = wcd_get_widget( $this->id );

		wp_register_style( "codesigner-{$this->id}", plugins_url( "assets/css/style{$min}.css", __FILE__ ), [], '1.1' );
		wp_enqueue_style( 'codesigner-font-awesome', 'https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css', array(), '6.4.0', 'all' );
		wp_register_script( "codesigner-{$this->id}", plugins_url( "assets/js/script{$min}.js", __FILE__ ), ['jquery'], '1.1', true );
	}

	public function get_script_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_style_depends() {
		return [ "codesigner-{$this->id}" ];
	}

	public function get_name() {
		return $this->id;
	}

	public function get_title() {
		return $this->widget['title'];
	}

	public function get_icon() {
		return $this->widget['icon'];
	}

	public function get_categories() {
		return $this->widget['categories'];
	}

	protected function register_controls() {

		$this->start_controls_section(
			'section_content_columns',
			[
				'label' => __( 'Display', 'codesigner-pro' ),
				'tab'   => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_responsive_control(
			'cart_heading_show_hide',
			[
				'label' 			=> __( ' Card Heading', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> esc_html__( 'Show', 'textdomain' ),
				'label_off' 		=> esc_html__( 'Hide', 'textdomain' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_control(
			'floating_cart_heading_text',
			[
				'label' 		=> __( 'Heading Text', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Cart',
				'placeholder' 	=> __( 'Type Section title here', 'codesigner-pro' ),
				'condition' 	=> [
					'cart_heading_show_hide' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'minimize_button_show_hide',
			[
				'label' 			=> __( 'Minimize Button', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'product_image_show_hide',
			[
				'label' 			=> __( 'Thumbnail', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'product_name_show_hide',
			[
				'label' 			=> __( 'Product Name', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'product_price_show_hide',
			[
				'label' 			=> __( 'Price', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'product_quantity_show_hide',
			[
				'label' 			=> __( 'Quantity', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'remove_product_show_hide',
			[
				'label' 			=> __( 'Remove Button', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_control(
			'remove_product_text',
			[
				'label' 		=> __( 'Remove Text', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::TEXT,
				'default' 		=> 'Remove',
				'placeholder' 	=> __( 'Type Section title here', 'codesigner-pro' ),
				'condition' 	=> [
					'remove_product_show_hide' => 'yes'
				],
			]
		);

		$this->add_responsive_control(
			'apply_coupon_show_hide',
			[
				'label' 			=> __( 'Coupon Apply', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);

		$this->add_responsive_control(
			'checkout_section_show_hide',
			[
				'label' 			=> __( 'Checkout Section', 'codesigner-pro' ),
				'type' 				=> Controls_Manager::SWITCHER,
				'label_on' 			=> __( 'Hide', 'codesigner-pro' ),
				'label_off' 		=> __( 'Show', 'codesigner-pro' ),
				'return_value' 		=> 'yes',
				'default'			=> 'yes',
				'desktop_default'	=> 'yes',
				'tablet_default'	=> 'yes',
				'mobile_default'	=> 'yes',
				'separator'			=> 'before',
			]
		);


        $this->add_control(
			'fc_chekcout_text',
			[
				'label' => __( 'Checkout Text', 'codesigner-pro' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Checkout',
				'placeholder' => __( 'Type Section title here', 'codesigner-pro' ),
				'condition' 	=> [
					'remove_product_show_hide' => 'yes'
				],
			]
		);

		$this->end_controls_section();

		/**
		 * Box style
		 */
		$this->start_controls_section(
			'section_style_icon_position',
			[
				'label' => __( 'Icon', 'codesigner-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'wl_cart_icon',
			[
				'label' => __( 'Cart Icon', 'codesigner-pro' ),
				'type' => Controls_Manager::ICONS,
				'default' => [
					'value' => 'fa fa-shopping-cart',
					'library' => 'solid',
				],
			]
		);

		$this->add_control(
			'icon_offset_toggle',
			[
				'label' 		=> __( 'Offset', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'label_off' 	=> __( 'None', 'codesigner-pro' ),
				'label_on' 		=> __( 'Custom', 'codesigner-pro' ),
				'return_value' 	=> 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'media_offset_x',
			[
				'label' 		=> __( 'Offset Left', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px', '%'],
				'condition' 	=> [
					'icon_offset_toggle' => 'yes'
				],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> -500,
						'max' 	=> 700,
						'step' 	=> 1,
					],
					'%' 		=> [
						'min' 	=> -100,
						'max' 	=> 150,
						'step' 	=> 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-icon' => 'left: {{SIZE}}{{UNIT}}'
				],
				'render_type' 	=> 'ui',
			]
		);

		$this->add_responsive_control(
			'media_offset_y',
			[
				'label' 		=> __( 'Offset Top', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px', '%'],
				'condition' 	=> [
					'icon_offset_toggle' => 'yes'
				],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> -500,
						'max' 	=> 700,
						'step' 	=> 1,
					],
					'%' 		=> [
						'min' 	=> -100,
						'max' 	=> 150,
						'step' 	=> 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 200,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-icon' => 'top: {{SIZE}}{{UNIT}}'
				]
			]
		);
		$this->end_popover();

		$this->add_control(
			'icon_bg_color',
			[
				'label' => esc_html__( 'Backgroud Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-icon' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'icon_section_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-icon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'icon_section_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-icon',
			]
		);

		$this->add_responsive_control(
			'icon_section_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-icon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'icon_text',
			[
				'label' => __('Icon Controls', 'codesigner-pro'),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'icon_color',
			[
				'label' => esc_html__( 'Icon Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-open-icon' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_responsive_control(
			'icon_size',
			[
				'label' => __( 'Icon Size', 'codesigner-pro' ),
				'type' 	=> Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' 	=> 0,
						'max' 	=> 1000,
						'step' 	=> 1,
					],
				],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-open-icon' => 'font-size: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'quantatity_text',
			[
				'label' => __('Quantatity Controls', 'codesigner-pro'),
				'type' => Controls_Manager::HEADING,
			]
		);

		$this->add_control(
			'quantatity_color',
			[
				'label' => esc_html__( 'Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-product-no' => 'color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'quantatity_bg_color',
			[
				'label' => esc_html__( 'Background Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-product-no' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'quantatity_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-cart-product-no',
			]
		);

		$this->add_responsive_control(
			'quantatity_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-product-no' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'quantatity_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-product-no',
			]
		);

		$this->add_responsive_control(
			'quantatity_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-product-no' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		/**
		 * Box style
		 */
		$this->start_controls_section(
			'floating_box_section',
			[
				'label' 		=> __( 'Box Style', 'codesigner-pro' ),
				'tab' 			=> Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'box_offset_toggle',
			[
				'label' 		=> __( 'Offset', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::POPOVER_TOGGLE,
				'label_off' 	=> __( 'None', 'codesigner-pro' ),
				'label_on' 		=> __( 'Custom', 'codesigner-pro' ),
				'return_value' 	=> 'yes',
			]
		);

		$this->start_popover();

		$this->add_responsive_control(
			'box_media_offset_x',
			[
				'label' 		=> __( 'Offset Left', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px', '%'],
				'condition' 	=> [
					'box_offset_toggle' => 'yes'
				],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> -500,
						'max' 	=> 700,
						'step' 	=> 1,
					],
					'%' 		=> [
						'min' 	=> -100,
						'max' 	=> 150,
						'step' 	=> 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 10,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-cart-inner' => 'left: {{SIZE}}{{UNIT}}'
				],
				'render_type' 	=> 'ui',
			]
		);

		$this->add_responsive_control(
			'box_media_offset_y',
			[
				'label' 		=> __( 'Offset Top', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::SLIDER,
				'size_units' 	=> ['px', '%'],
				'condition' 	=> [
					'box_offset_toggle' => 'yes'
				],
				'range' 		=> [
					'px' 		=> [
						'min' 	=> -500,
						'max' 	=> 700,
						'step' 	=> 1,
					],
					'%' 		=> [
						'min' 	=> -100,
						'max' 	=> 150,
						'step' 	=> 1,
					],
				],
				'default' => [
					'unit' => '%',
					'size' => 35,
				],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-cart-inner' => 'top: {{SIZE}}{{UNIT}}'
				]
			]
		);
		$this->end_popover();

		$this->add_responsive_control(
			'cart_height',
			[
				'label' => __( 'Cart height', 'codesigner-pro' ),
				'type' 	=> Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' 	=> 0,
						'max' 	=> 1000,
						'step' 	=> 1,
					],
				],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-inner' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_responsive_control(
			'cart_width',
			[
				'label' => __( 'Cart width', 'codesigner-pro' ),
				'type' 	=> Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' 	=> 0,
						'max' 	=> 1000,
						'step' 	=> 1,
					],
				],
				'default' => [
					'unit' => 'px',
					'size' => 400,
				],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-inner' => 'width: {{SIZE}}{{UNIT}};',
				],
			]
		);
		
		$this->add_control(
			'box_bg_color',
			[
				'label' => esc_html__( 'Backgroud Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-inner' => 'background-color: {{VALUE}}',
				],
			]
		);


		$this->add_responsive_control(
			'box_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-inner' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'box_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-inner',
			]
		);

		$this->add_responsive_control(
			'box_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-inner' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();       
		

		/**
		 * Cart Section 
		 */
		$this->start_controls_section(
			'floating_cart',
			[
				'label' => __( 'Cart Heading', 'codesigner-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'cart_title_color',
                'selector' => '{{WRAPPER}} .wl-floating-cart-header',
            ]
        );
        $this->add_control(
			'cart_title_bg_color',
			[
				'label' => esc_html__( 'Backgroud Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-wapper' => 'background-color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'cart_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    // 'line_height'   => [ 'default' => [ 'size' => 37 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-cart-header',
			]
		);
		$this->end_controls_section();


		 /**
         * cart table style
         */
		$this->start_controls_section(
			'style_section_cart_table',
			[
				'label' => __( 'Table', 'codesigner-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'cart_table_background',
				'label' 	=> __( 'Background', 'codesigner-pro' ),
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-table',
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'cart_table_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-table',
				'separator' => 'before'
			]
		);

		$this->add_responsive_control(
			'cart_table_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-table' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'cart_table_box_shadow',
				'label' 	=> __( 'Box Shadow', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-table',
			]
		);

		$this->add_responsive_control(
			'cart_table_shadow_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-table' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before'
			]
		);

		$this->add_responsive_control(
			'cart_table_shadow_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-table' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);
		$this->end_controls_section();
		/**
		 * Image controllers
		 */
		/**
		 * Product Image controls
		 */
		$this->start_controls_section(
			'section_style_image',
			[
				'label' => __( 'Product Image', 'codesigner-pro' ),
				'tab'   => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_responsive_control(
			'image_width',
			[
				'label' 	=> __( 'Image Width', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'size_units'=> [ 'px', '%', 'em' ],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image a img' => 'width: {{SIZE}}{{UNIT}}',
				],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 1,
						'max' 	=> 250
					],
					'em' 	=> [
						'min' 	=> 1,
						'max' 	=> 30
					],
				],
			]
		);

		$this->add_responsive_control(
			'image_height',
			[
				'label' 	=> __( 'Image Height', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'size_units'=> [ 'px', '%', 'em' ],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image a img' => 'height: {{SIZE}}{{UNIT}}',
				],
				'range' 	=> [
					'px' 	=> [
						'min' 	=> 1,
						'max' 	=> 250
					],
					'em' 	=> [
						'min' 	=> 1,
						'max' 	=> 30
					],
				],
			]
		);

		$this->add_responsive_control(
			'image_box_height',
			[
				'label' 	=> __( 'Image Box Height', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'size_units'=> [ 'px', 'em' ],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image' => 'height: {{SIZE}}{{UNIT}}',
				],
                'range'     => [
                    'px'    => [
                        'min'   => 1,
                        'max'   => 500
                    ],
                    'em'    => [
                        'min'   => 1,
                        'max'   => 30
                    ],
                ],
			]
		);

		$this->add_responsive_control(
			'image_box_width',
			[
				'label' 	=> __( 'Image Box Width', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'size_units'=> [ 'px', 'em' ],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image' => 'width: {{SIZE}}{{UNIT}}',
				],
                'range'     => [
                    'px'    => [
                        'min'   => 1,
                        'max'   => 500
                    ],
                    'em'    => [
                        'min'   => 1,
                        'max'   => 30
                    ],
                ],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'image_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-product-image a img',
			]
		);

		$this->add_responsive_control(
			'image_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-product-image a img' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Box_Shadow::get_type(),
			[
				'name' 		=> 'image_box_shadow',
				'label' 	=> __( 'Box Shadow', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-product-image a img',
			]
		);

		$this->start_controls_tabs(
			'image_effects',
			[
				'separator' => 'before'
			]
		);

		$this->start_controls_tab(
			'image_effects_normal',
			[
				'label' 	=> __( 'Normal', 'codesigner-pro' ),
			]
		);

		$this->add_control(
			'image_opacity',
			[
				'label' 	=> __( 'Opacity', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'range' 	=> [
					'px' 	=> [
						'max' 	=> 1,
						'min' 	=> 0.10,
						'step' 	=> 0.01,
					],
				],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image a img' => 'opacity: {{SIZE}};',
				],
			]
		);

		// $this->add_group_control(
		// 	Group_Control_Css_Filter::get_type(),
		// 	[
		// 		'name' 		=> 'image_css_filters',
		// 		'selector' 	=> '.wl {{WRAPPER}} .wl-floating-product-image a img',
		// 	]
		// );

		$this->end_controls_tab();

		$this->start_controls_tab( 'image_hover',
			[
				'label' 	=> __( 'Hover', 'codesigner-pro' ),
			]
		);

		$this->add_control(
			'image_opacity_hover',
			[
				'label' 	=> __( 'Opacity', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'range' 	=> [
					'px' 	=> [
						'max' 	=> 1,
						'min' 	=> 0.10,
						'step' 	=> 0.01,
					],
				],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image a img:hover' => 'opacity: {{SIZE}};',
				],
			]
		);

		// $this->add_group_control(
		// 	Group_Control_Css_Filter::get_type(),
		// 	[
		// 		'name' 		=> 'image_css_filters_hover',
		// 		'selector' 	=> '.wl {{WRAPPER}} .wl-floating-product-image a img:hover',
		// 	]
		// );

		$this->add_control(
			'image_hover_transition',
			[
				'label' 	=> __( 'Transition Duration', 'codesigner-pro' ),
				'type' 		=> Controls_Manager::SLIDER,
				'range' 	=> [
					'px' 	=> [
						'max' 	=> 3,
						'step' 	=> 0.1,
					],
				],
				'selectors' => [
					'.wl {{WRAPPER}} .wl-floating-product-image a img:hover' => 'transition-duration: {{SIZE}}s',
				],
			]
		);

		$this->end_controls_tab();
		$this->end_controls_tabs();
		$this->end_controls_section();
		/**
         * Product Title
         */
        $this->start_controls_section(
            'fc_product_title',
            [
                'label' => __( 'Product Title', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'title_color',
                'selector' => '{{WRAPPER}} .wl-floating-product-title-inner',
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'title_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    // 'line_height'   => [ 'default' => [ 'size' => 37 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-product-title-inner',
			]
		);
		$this->end_controls_section();

		/**
         * Product Price 
         */
        $this->start_controls_section(
            'fc_product_price',
            [
                'label' => __( 'Product Price', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'Price_Color',
                'selector' => '{{WRAPPER}} .wl-floating-price',
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'price_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    // 'line_height'   => [ 'default' => [ 'size' => 37 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-price',
			]
		);
		$this->end_controls_section();

		/**
         * Remove 
         */
        $this->start_controls_section(
            'fc_remove_text',
            [
                'label' => __( 'Remove Text', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Gradient_Text::get_type(),
            [
                'name' => 'remove_text_Color',
                'selector' => '{{WRAPPER}} .wl-fc-remove',
            ]
        );

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'remove_text_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    // 'line_height'   => [ 'default' => [ 'size' => 37 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-fc-remove',
			]
		);	

		$this->end_controls_section();

		/**
         * coupon section
         */
        $this->start_controls_section(
            'coupon_section',
            [
                'label' => __( 'Coupon Section', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_responsive_control(
			'coupon_height',
			[
				'label' => __( 'Coupon Section height', 'codesigner-pro' ),
				'type' 	=> Controls_Manager::SLIDER,
				'size_units' => [ 'px' ],
				'range' => [
					'px' => [
						'min' 	=> 0,
						'max' 	=> 1000,
						'step' 	=> 1,
					],
				],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-coupon-section' => 'height: {{SIZE}}{{UNIT}};',
				],
			]
		);

		$this->add_control(
			'coupon_bg_color',
			[
				'label' => esc_html__( 'Backround Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-coupon-section' => 'background-color: {{VALUE}}',
				],
			]
		);

		$this->add_control(
			'coupon_input_heading_text',
			[
				'label' => __('Coupon Input Control', 'codesigner-pro'),
				'type' => Controls_Manager::HEADING,
			]
		);
		
		$this->add_control(
			'coupon_checked_color',
			[
				'label' => esc_html__( 'Input Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-coupon::placeholder' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'coupon_typography',
				'label' 	=> __( 'Input Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 19 ] ],
                    'line_height'   => [ 'default' => [ 'size' => 20 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-cart-coupon',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'coupon_background',
				'label' 	=> __( 'Input Backgroud Color', 'codesigner-pro' ),
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-cart-coupon',
			]
		);

		$this->add_responsive_control(
			'coupon_input_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-cart-coupon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before',
				'desktop_default' => [
					'padding' 	=> 10,
					'unit' 		=> 'px',
				],
			]
		);

		$this->add_responsive_control(
			'coupon_input_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-cart-coupon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		
		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'coupon_input_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} .wl-floating-cart-coupon',
			]
		);

		$this->add_responsive_control(
			'coupon_input_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} .wl-floating-cart-coupon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);


		$this->add_control(
			'coupon_button_input_heading_text',
			[
				'label' => __('Coupon Button Control', 'codesigner-pro'),
				'type' => Controls_Manager::HEADING,
			]
		);
		
		$this->add_control(
			'coupon_button_checked_color',
			[
				'label' => esc_html__( 'Button Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} #co_apply_coupon' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'coupon_button_typography',
				'label' 	=> __( 'Button Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    'line_height'   => [ 'default' => [ 'size' => 20 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} #co_apply_coupon',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' 		=> 'coupon_button_background',
				'label' 	=> __( 'Button Backgroud Color', 'codesigner-pro' ),
				'types' 	=> [ 'classic', 'gradient' ],
				'selector' 	=> '{{WRAPPER}} #co_apply_coupon',
			]
		);

		$this->add_responsive_control(
			'coupon_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #co_apply_coupon' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before'
			]
		);

		$this->add_responsive_control(
			'coupon_margin',
			[
				'label' 		=> __( 'Margin', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} #co_apply_coupon' => 'margin: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Border::get_type(),
			[
				'name' 		=> 'coupon_border',
				'label' 	=> __( 'Border', 'codesigner-pro' ),
				'selector' 	=> '.wl {{WRAPPER}} #co_apply_coupon',
			]
		);

		$this->add_responsive_control(
			'coupon_border_radius',
			[
				'label' 		=> __( 'Border Radius', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%' ],
				'selectors' 	=> [
					'.wl {{WRAPPER}} #co_apply_coupon' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
			]
		);

		$this->end_controls_section();
		
		/**
         * checkout
         */
        $this->start_controls_section(
            'fc_chekcout',
            [
                'label' => __( 'Checkout Section', 'codesigner-pro' ),
                'tab'   => Controls_Manager::TAB_STYLE,
            ]
        );

		$this->add_control(
			'checked_color',
			[
				'label' => esc_html__( 'Text Color', 'codesigner-pro' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .wl-floating-cart-checkout' => 'color: {{VALUE}}',
				],
			]
		);

        $this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name' 		=> 'checkout_typography',
				'label' 	=> __( 'Typography', 'codesigner-pro' ),
				'scheme' 	=> Typography::TYPOGRAPHY_3,
                'fields_options'    => [
                    'typography'    => [ 'default' => 'yes' ],
                    'font_size'     => [ 'default' => [ 'size' => 16 ] ],
                    'line_height'   => [ 'default' => [ 'size' => 20 ] ],
                    'font_family'   => [ 'default' => 'Montserrat' ],
                    'font_weight'   => [ 'default' => 500 ],
                ],
				'selector' 	=> '{{WRAPPER}} .wl-floating-cart-checkout',
			]
		);

		$this->add_group_control(
			Group_Control_Background::get_type(),
			[
				'name' => 'checkout_background',
				'types' => [ 'classic', 'gradient' ],
				'selector' => '{{WRAPPER}} .wl-floating-cart-checkout',
			]
		);


		$this->add_responsive_control(
			'heckout_input_padding',
			[
				'label' 		=> __( 'Padding', 'codesigner-pro' ),
				'type' 			=> Controls_Manager::DIMENSIONS,
				'size_units' 	=> [ 'px', '%', 'em' ],
				'selectors' 	=> [
					'{{WRAPPER}} .wl-floating-cart-checkout' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
				],
				'separator'		=> 'before'
			]
		);


		$this->end_controls_section();
	}
	

	protected function render() {
		if( is_null( WC()->cart ) ) {
			include_once WC_ABSPATH . 'includes/wc-cart-functions.php';
			include_once WC_ABSPATH . 'includes/class-wc-cart.php';
			wc_load_cart();
		}

		global $woocommerce;
		$settings 			= $this->get_settings_for_display();
		extract( $settings );
		$cart 			= WC()->cart;
		$cartQuantity 	= $cart->get_cart_contents_count();
		$cart_is_empty 	= $cart->is_empty();

		?>
		<?php do_action( 'woocommerce_before_cart' ); ?>
		<div class="wl-floating-icon" <?php if( $cart_is_empty == true ){ ?> style="display:none;" <?php  }  ?> >
				<i class="wl-floating-open-icon <?php echo __( $wl_cart_icon['value'], 'codesigner-pro' ) ?>"> </i>
				<span class="wl-floating-cart-product-no"><?php echo __( $cartQuantity , 'codesigner-pro'  ) ?> </span>
		</div>
		<div class="wl-floating-cart" <?php if( wcd_is_edit_mode() == false ){ ?> style="display:none;" <?php  }  ?>  >
			<div class="wl-floating-cart-inner">
				<div class="wl-floating-cart-wapper">
					<div class="wl-floating-cart-header">
						<?php if ( $settings['cart_heading_show_hide'] == 'yes' ) : ?>
							<span class="wl-floating-cart-header-left">
								<span class="wl-floating-cart-title"><?php echo __( $settings['floating_cart_heading_text'] , '' ) ?></span>
							</span>
						<?php endif; ?>
					</div>
					<div class="wl-floating-cart-icon">
						<?php if ( $settings['minimize_button_show_hide'] ) : ?>
							<i class="fas fa-times"></i>
						<?php endif; ?>
					</div>        		
				</div>
				<div class="wl-floating-cart-body">
					<table class="wl-floating-cart-table" >
					<?php
					if ( $cart->get_cart() ) {
						foreach( $cart->get_cart() as $item ){ 
							$product_id 		= $item['product_id'];
							$wc_product 		= wc_get_product( $product_id );
							$subtotal[]			= WC()->cart->get_product_subtotal( $item['data'], $item['quantity'] );
							$image_url_array 	= wp_get_attachment_image_src( get_post_thumbnail_id( $product_id ), 'single-post-thumbnail' );

							?>
							<tr class="wl-floating-product wl-floating-simple" data-key="<?php echo $item['key'] ?>" data-id="<?php echo $item['product_id'] ?>">
								<?php if ( $settings['product_image_show_hide'] ) : ?>
									<td class="wl-floating-product-image">
										<a href="<?php echo get_permalink( $product_id ) ?>">
											<img  src="<?php echo $image_url_array[0] ?>" class="attachment-woocommerce_thumbnail size-woocommerce_thumbnail" alt="<?php echo $wc_product->get_name() ?>" >
										</a>
									</td>
								<?php endif; ?>
								<td>
									<?php if ( $settings['product_name_show_hide'] ) : ?>
										<span class="wl-floating-product-title">
											<a class="wl-floating-product-title-inner" href="<?php echo get_permalink( $product_id ) ?>"><?php echo __( $wc_product->get_name() , 'codesigner-pro' ) ?> </a>
										</span>
									<?php endif; ?>
									<?php if ( $settings['product_quantity_show_hide'] ) : ?>
										<div class="wl-floating-quantity-row">
											<span class="wl-floating-quantity-col wl-floating-quantity-col-minus wl-floating-quantity-button" data-action='decrement' >
												<i class="fa fa-minus" aria-hidden="true"></i>
											</span>
											<span class="wl-floating-quantity-col wl-floating-quantity-col-input">
												<input type="number" class="wl-fc-input-text qty text" data-key="<?php echo $item['key'] ?>" step="1" readonly min="1" max="" name="" value="<?php echo __( $item['quantity'], 'codesigner-pro' )  ?>" title="Qty" placeholder="" inputmode="numeric">
											</span>
											
											<span class="wl-floating-quantity-col wl-floating-quantity-col-plus wl-floating-quantity-button" data-action='increment' >
												<i class="fa fa-plus" aria-hidden="true"></i>
											</span>
										</div>
									<?php endif; ?>
								</td>
								<td>
									<?php if ( $settings['product_price_show_hide'] ) : ?>
										<span class="wl-floating-price amount" data-key="<?php echo __( $item['key'], 'codesigner-pro' ) ?>">
											<span class="woocommerce-Price-currencySymbol">$</span><?php echo __( $item['line_subtotal'], 'codesigner-pro' )?></bdi>
										</span>
									<?php endif; ?>
									<?php if ( $settings['remove_product_show_hide'] ) : ?>
										<span class="wl-fc-remove"> <?php echo __( $remove_product_text, 'codesigner-pro' )  ?> </span>
									<?php endif; ?>
								</td>
							</tr>
						<?php
						} 
					}
					?>
					</table>
				</div> 
				<?php if ( $settings['apply_coupon_show_hide'] ) :
					if ( wc_coupons_enabled() ) { ?>
						<div class="wl-floating-cart-coupon-section">
							<input type="text" name="co_coupon_code" class="wl-floating-cart-coupon" id="co_coupon_code" value="" placeholder="<?php echo esc_attr_e( 'Apply Coupon', 'codesigner-pro' ); ?>" />
							<?php 
							printf( '<button %1$s type="submit" name="co_apply_coupon" id="co_apply_coupon" value="%2$s">%2$s</button>',
								$this->get_render_attribute_string( 'Coupon_button_name' ),
								esc_html__( 'Appply', 'codesigner-pro' )
							);
							?>
						</div>
					<?php }
				endif; ?>
				<div class="coupon-applied-div"></div>
				<?php if ( $settings['checkout_section_show_hide'] ) : ?>
					<div class="wl-floating-cart-footer">					
						<a href=" <?php echo wc_get_checkout_url(); ?> " class="wl-floating-cart-checkout wl-floating-cart-btn">
							<span class="wl-floating-cart-footer-label" ><?php echo __( $fc_chekcout_text , 'codesigner-pro' ) ?></span>
							<span class="wl-floating-cart-dash">-</span>
							<span class="wl-amount"><?php  echo __( WC()->cart->get_total(), 'codesigner-pro' ) ?></span>
						</a>			
					</div> 
				<?php endif ?>       		
					<div class="wl-floating-cart-spenier-wrap"></div>        		
				</div>
			</div>
			
		<?php
			/**
			 * Load Script
			 */
			// $this->render_script( $notifications );

			do_action( 'wcd_floating_cart_end' );
		}

		protected function render_script( $all_notifications ) {
			$settings = $this->get_settings_for_display();

			if ( wcd_is_edit_mode() ) {
				?>
				<script type="text/javascript">
				jQuery(function($){						
					
				})
				</script>
				<?php
				return;
			}			
		}
	}



